(* ::Package:: *)

clear all
clc
tic

load yF_ 212;


ipi=yF_ 212(1:end,1);
inf=yF_ 212(1:end,2);
unp=yF_ 212(1:end,3);
pr=yF_ 212(1:end,4);
sp=yF_ 212(1:end,5);

R=100;B=100; q=23; transpos=5; const=1;
shockv=4; shock=-1; % which is the medium value

% start=180; %180 ; which is January 1995
% T=length(fci)-start;

start=1; %180 ; which is January 2000
T=length(sp)-start;

% output_low _fci _ 1=cell(T+1,1);
% output_high _fci _ 1=cell(T+1,1);
% results_VSTAR=cell(T+1,1);

output_low _sp _ 1=cell(T+1,1);
output_high _sp _ 1=cell(T+1,1);
results_VSTAR=cell(T+1,1);

Lstat=zeros(3,T);
Lprob=zeros(3,T);
tc=zeros(T,1);

for t=T:T

%   y=[ip(1:start+t),fci(1:start+t)]; 
%   trans=[fci(1:start+t), fci(1:start+t)];
    
    y=[ipi(1:start+t), inf(1:start+t), unp(1:start+t), pr(1:start+t), sp(1:start+t)]; 
    trans=[sp(1:start+t), sp(1:start+t), sp(1:start+t), sp(1:start+t), sp(1:start+t)];
     
    for tl=1:5
%       translag_tl=[tl tl];
        translag_tl=[tl tl tl tl tl];
        [output_lintest] = lintest_stvar _LM(y,trans,translag_tl);
        Lstat(tl,t+1)=output_lintest(end,1); % Rao
        Lprob(tl,t+1)=output_lintest(end,2); % Rao
    end
    [junk,translag_common]=min(Lprob(:,t+1));
    tc(t+1,1)=translag_common;
    
%     if sum(Lprob(:,t+1)>0.1)==3
%         break
%     end
    
    lagsel='infc';pmax=round(12*(length (y(:,1))/100)^(1/4));
    [valic_ic,valic_corr _ic,nlag_ic]=lagselec_var(y,pmax,'infc','BIC',0,1); 

    laglen=nlag_ic;
    pmax=laglen;

    % starting value search and estimation
    dep=y(laglen+1:end,:);
    ylag1l=mlag(y,laglen);     ylag1l=ylag1l(laglen+1:end,:);
    ylag1nl=ylag1l; ylag2l=ylag1l; ylag2nl=ylag1l;
    ylag3l = ylag1l; ylag3nl = ylag1l;
    ylag4l = ylag1l; ylag4nl = ylag1l;
    ylag5l = ylag1l; ylag5nl = ylag1l;
    
%   transvar=lag(fci(1:start+t),translag_common);
    transvar=lag(sp(1:start+t),translag_common);
    transvar=transvar(laglen+1:end,:);

    [startval_de,max_likeli _de]=sv_ho _de _vector _sur _ 21_nu _rirf(dep,ylag1l,ylag1nl,ylag2l,ylag2nl,ylag3l,ylag3nl,ylag4l,ylag4nl,ylag5l,ylag5nl,transvar);
    startval=startval_de';
    regs_ 1.eq{:,1}=ylag1l; % eq1 linear
    regs_ 1.eq{:,2}=ylag1nl; % eq1 nonlinear
    regs_ 2.eq{:,1}=ylag2l; % eq2 linear
    regs_ 2.eq{:,2}=ylag2nl; % eq2 nonlinear
    regs_ 3.eq{:,1}=ylag3l; % eq3 linear
    regs_ 3.eq{:,2}=ylag3nl; % eq3 nonlinear
    regs_ 4.eq{:,1}=ylag4l; % eq4 linear
    regs_ 4.eq{:,2}=ylag4nl; % eq4 nonlinear
    regs_ 5.eq{:,1}=ylag5l; % eq5 linear
    regs_ 5.eq{:,2}=ylag5nl; % eq5 nonlinear

    [results_VSTAR{t+1,1}] = vstar_est _ML _nu _const(dep,regs_ 1.eq,regs_ 2.eq,regs_ 3.eq,regs_ 4.eq,regs_ 5.eq,transvar,startval');    
    results_vstar _est=results_VSTAR{t+1,1};
    nlag=laglen;   
    x=[regs_ 1.eq regs_ 2.eq regs_ 3.eq regs_ 4.eq regs_ 5.eq];
  
    hist=0;   
    param_setting=[R,B,hist,q,nlag,pmax,translag_common,transpos,shockv,shock,const];
    output_low _sp _ 1{t+1,1} = nonlinear_IRF _VSTAR _IV _rirf(results_vstar _est,y,x,transvar,param_setting);

    hist=1;  
    param_setting=[R,B,hist,q,nlag,pmax,translag_common,transpos,shockv,shock,const];
    output_high _sp _ 1{t+1,1} = nonlinear_IRF _VSTAR _IV _rirf(results_vstar _est,y,x,transvar,param_setting);


end

clc
rirf_low=zeros(24,T+1);
rirf_high=zeros(24,T+1);

for t=T:T
   rirf_low(:,t+1)=output_low _sp _ 1{t+1,1}.GIRFcum(1,1).eq(:,2);
   rirf_high(:,t+1)=output_high _sp _ 1{t+1,1}.GIRFcum(1,1).eq(:,2);
end

time=toc;

% plot(output_high _fci _ 1{218,1}.GIRFcum(1,1).eq)

figure(1)
clf(1)
x = 1:24;
annotation('textbox', [0 0.9 1 0.1], ...
    'String', 'Netherlands, low fragmentation', ...
    'EdgeColor', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', 14, ...
    'FontWeight', 'bold')

subplot(3,2,1)
down = output_low _sp _ 1{t+1,1}.GIRFcum(1).eq(:,1)';
middle = output_low _sp _ 1{t+1,1}.GIRFcum(1).eq(:,2)';
up = output_low _sp _ 1{t+1,1}.GIRFcum(1).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('IPI')
xlabel('Time (months)')

subplot(3,2,2)
down = output_low _sp _ 1{t+1,1}.GIRFcum(2).eq(:,1)';
middle = output_low _sp _ 1{t+1,1}.GIRFcum(2).eq(:,2)';
up = output_low _sp _ 1{t+1,1}.GIRFcum(2).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Inflation')
xlabel('Time (months)')

subplot(3,2,3)
down = output_low _sp _ 1{t+1,1}.GIRFcum(3).eq(:,1)';
middle = output_low _sp _ 1{t+1,1}.GIRFcum(3).eq(:,2)';
up = output_low _sp _ 1{t+1,1}.GIRFcum(3).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Unemployment')
xlabel('Time (months)')

subplot(3,2,4)
down = output_low _sp _ 1{t+1,1}.GIRFcum(4).eq(:,1)';
middle = output_low _sp _ 1{t+1,1}.GIRFcum(4).eq(:,2)';
up = output_low _sp _ 1{t+1,1}.GIRFcum(4).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('EONIA')
xlabel('Time (months)')

subplot(3,2,5)
down = output_low _sp _ 1{t+1,1}.GIRFcum(5).eq(:,1)';
middle = output_low _sp _ 1{t+1,1}.GIRFcum(5).eq(:,2)';
up = output_low _sp _ 1{t+1,1}.GIRFcum(5).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Spread (country vs. EUR average)')
xlabel('Time (months)')

figure(2)
clf(2)
x = 1:24;
annotation('textbox', [0 0.9 1 0.1], ...
    'String', 'Netherlands, high fragmentation', ...
    'EdgeColor', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', 14, ...
    'FontWeight', 'bold')

subplot(3,2,1)
down = output_high _sp _ 1{t+1,1}.GIRFcum(1).eq(:,1)';
middle = output_high _sp _ 1{t+1,1}.GIRFcum(1).eq(:,2)';
up = output_high _sp _ 1{t+1,1}.GIRFcum(1).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('IPI')
xlabel('Time (months)')

subplot(3,2,2)
down = output_high _sp _ 1{t+1,1}.GIRFcum(2).eq(:,1)';
middle = output_high _sp _ 1{t+1,1}.GIRFcum(2).eq(:,2)';
up = output_high _sp _ 1{t+1,1}.GIRFcum(2).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Inflation')
xlabel('Time (months)')

subplot(3,2,3)
down = output_high _sp _ 1{t+1,1}.GIRFcum(3).eq(:,1)';
middle = output_high _sp _ 1{t+1,1}.GIRFcum(3).eq(:,2)';
up = output_high _sp _ 1{t+1,1}.GIRFcum(3).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Unemployment')
xlabel('Time (months)')

subplot(3,2,4)
down = output_high _sp _ 1{t+1,1}.GIRFcum(4).eq(:,1)';
middle = output_high _sp _ 1{t+1,1}.GIRFcum(4).eq(:,2)';
up = output_high _sp _ 1{t+1,1}.GIRFcum(4).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('EONIA')
xlabel('Time (months)')

subplot(3,2,5)
down = output_high _sp _ 1{t+1,1}.GIRFcum(5).eq(:,1)';
middle = output_high _sp _ 1{t+1,1}.GIRFcum(5).eq(:,2)';
up = output_high _sp _ 1{t+1,1}.GIRFcum(5).eq(:,3)';
fill([x fliplr(x)], [down fliplr(up)], [0.9, 0.9, 0.9], 'LineStyle', 'none')
hold on
plot(x, down, '--b', x, up, '--b', x, middle, 'k')
title('Spread (country vs. EUR average)')
xlabel('Time (months)')

figure(3)
clf(3)
std_trans=std(transvar);
transvar= sort(transvar);
transfunc = (1+exp(-results_vstar_est.param(end)/std_trans*(transvar(:,1)-results_vstar _est.param(end-1)))).^(-1);
hold on
plot(transvar,transfunc,'b-o')
annotation('textbox', [0 0.9 1 0.1], ...
    'String', 'Transition function', ...
    'EdgeColor', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', 14, ...
    'FontWeight', 'bold')
xlabel('Transition variable')
ylabel('Smoothness parameter')
